#ifndef _CDynString_CPP
#define _CDynString_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "../CMemPool/CMemPool.H"

#include "CDynString.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CDynString::Init(void)
{
	return InitEx(DYNSTRINGCHUNKSZ);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CDynString::InitEx(const int iInAllocAhead)
{
	ciAllocAhead = iInAllocAhead;

	if((csDataBuf = (char *) gMem.Allocate(sizeof(char), ciAllocAhead + 1)) == NULL)
	{
		return false;
	}

	ciAlloc = ciAllocAhead;
	ciBufSz = 0;

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CDynString::Truncate(void)
{
	ciBufSz = 0;

	csDataBuf[0] = '\0';

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CDynString::Free(void)
{
	ciAllocAhead = 0;
	ciAlloc = 0;
	ciBufSz = 0;

	gMem.Free(csDataBuf);
	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CDynString::AppendEx(const char *sDat2Append, const int iDat2AppendSz)
{
	int iRPos = 0;

	//Do we have enough RAM allocated for the newly read data?
	if((ciBufSz + iDat2AppendSz) >= ciAlloc)
	{
		//Figure out how much more RAM we will need (And add a few more to it).
		ciAlloc = (ciAlloc + iDat2AppendSz + ciAllocAhead) + 1;

		//Allocate more RAM.
		csDataBuf = (char *) gMem.ReAllocate(csDataBuf, ciAlloc);
	}

	while(iRPos < iDat2AppendSz)
	{
		csDataBuf[ciBufSz++] = sDat2Append[iRPos++];
	}

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CDynString::Append(const char *sDat2Append)
{
	return AppendEx(sDat2Append, strlen(sDat2Append));
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CDynString::AppendI(const int iNum)
{
	char sNum[32];

	sprintf_s(sNum, sizeof(sNum), "%d", iNum);

	return Append(sNum);
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool CDynString::AppendFile(const char *sFileName)
{
	int iBytesRead = 0;

	char sBuffer[DYNSTRINGCHUNKSZ + 1];

	FILE *hSource = NULL;

	if(fopen_s(&hSource, sFileName, "rb") != 0)
	{
		return false;
	}

	do{
		iBytesRead = fread(sBuffer, sizeof(char), DYNSTRINGCHUNKSZ, hSource);
		AppendEx(sBuffer, iBytesRead);
	} while(iBytesRead == DYNSTRINGCHUNKSZ);

	fclose(hSource);

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

